
// ============================================================================
//
// This file contains routines that are handled only during the Edittime,
// under the Frame and Event editors.
//
// Including creating, display, and setting up your object.
// 
// ============================================================================

#define EDITTIME_CPP

// Common
#include	"common.h"

#include <commctrl.h>

//strings for edit-time
#ifndef RUN_ONLY
char * EffectList[] = {"None","Semi-transparent","Inverted","Xor","And","Or","And Not",
						/*"Test",*/NULL};
#endif
BlitOp EffectCodes[] = {BOP_COPY,BOP_BLEND,BOP_INVERT,BOP_XOR,BOP_AND,BOP_OR,
						BOP_ANDNOT,/*BOP_BLEND_REPLACETRANSP,*/BOP_MAX};

#if !defined(RUN_ONLY)

// PROPERTIES /////////////////////////////////////////////////////////////////

// Property identifiers
enum {
	PROPID_SETTINGS = PROPID_EXTITEM_CUSTOM_FIRST,
	PROPID_IMAGEGRP,
	PROPID_IMAGELST,
	PROPID_GENSET,
	PROPID_VISIBLE,
	PROPID_STRETCH,
	PROPID_AUTOMATIC,
	PROPID_IMMEDIATE,
	PROPID_ABSOLUTE,
	PROPID_KEEPPOINTS,
// Example
// -------
//	PROPID_TEXTTITLE,	
//	PROPID_TEXT,	
//	PROPID_CHECK,
//	PROPID_COMBO,
//	PROPID_COLOR,
};

// Example of content of the PROPID_COMBO combo box
//LPCSTR ComboList[] = {
//	0,	// reserved
//	MAKEINTRESOURCE(IDS_FIRSTOPTION),	
//	MAKEINTRESOURCE(IDS_SECONDOPTION),	
//	MAKEINTRESOURCE(IDS_THIRDOPTION),	
//	NULL
//};

// Property definitions
//
// Type, ID, Text, Text of Info box [, Options, Init Param]
//
PropData Properties[] = {

// Example
// -------
//	PropData_Group		(PROPID_TEXTTITLE,	IDS_PROP_TEXTTITLE,		IDS_PROP_TEXTTITLE),
//	PropData_EditString	(PROPID_TEXT,		IDS_PROP_TEXT,			IDS_PROP_TEXT_INFO),
//	PropData_CheckBox	(PROPID_CHECK,		IDS_PROP_CHECK,			IDS_PROP_CHECK_INFO),
//	PropData_ComboBox	(PROPID_COMBO,		IDS_PROP_COMBO,			IDS_PROP_COMBO,	ComboList),
//	PropData_Color		(PROPID_COLOR,		IDS_PROP_COLOR,			IDS_PROP_COLOR_INFO),

	// End of table (required)
	PropData_Group(PROPID_IMAGEGRP,IDS_PROP_IMAGEGRP,IDS_PROP_IMAGEGRP),
	PropData_ImageList( PROPID_IMAGELST, IDS_PROP_IMAGELST,IDS_PROP_IMAGELST_INFO),
	PropData_Group(PROPID_GENSET,IDS_PROP_GENSET,IDS_PROP_GENSET),
	PropData_CheckBox(PROPID_VISIBLE,IDS_PROP_VISIBLE,IDS_PROP_VISIBLE_INFO),
	PropData_CheckBox(PROPID_STRETCH,IDS_PROP_STRETCH,IDS_PROP_STRETCH_INFO),
	PropData_CheckBox(PROPID_AUTOMATIC,IDS_PROP_AUTOMATIC,IDS_PROP_AUTOMATIC_INFO),
	PropData_CheckBox(PROPID_IMMEDIATE,IDS_PROP_IMMEDIATE,IDS_PROP_IMMEDIATE_INFO),
	PropData_CheckBox(PROPID_ABSOLUTE,IDS_PROP_ABSOLUTE,IDS_PROP_ABSOLUTE_INFO),
	PropData_CheckBox(PROPID_KEEPPOINTS,IDS_PROP_KEEPPOINTS,IDS_PROP_KEEPPOINTS_INFO),
	PropData_End()
};

// SETUP PROC /////////////////////////////////////////////////////////////////

// Prototype of setup procedure
BOOL CALLBACK DLLExport setupProc(HWND hDlg,uint msgType,WPARAM wParam,LPARAM lParam);

// Structure defined to pass edptr and mv in setup box
typedef struct tagSetP
{
	EDITDATA _far *	edpt;
	mv _far	*		kv;
	//WORD			imgidx;
} setupParams;

#endif // !defined(RUN_ONLY)


// -----------------
// GetObjInfos
// -----------------
// Return object info
//
// Info displayed in the object's About properties
// Note: ObjComment is also displayed in the Quick Description box in the Insert Object dialog box
//
void WINAPI	DLLExport GetObjInfos (mv _far *mV, LPEDATA edPtr, LPSTR ObjName, LPSTR ObjAuthor, LPSTR ObjCopyright, LPSTR ObjComment, LPSTR ObjHttp)
{
#ifndef RUN_ONLY
	// Name
	LoadString(hInstLib, IDST_OBJNAME,ObjName, 255);

	// Author
	LoadString(hInstLib, IDST_AUTHOR,ObjAuthor,255);

	// Copyright
	LoadString(hInstLib, IDST_COPYRIGHT,ObjCopyright,255);

	// Comment
	LoadString(hInstLib, IDST_COMMENT,ObjComment,1024);

	// Internet address
	LoadString(hInstLib, IDST_HTTP,ObjHttp,255);
#endif // !defined(RUN_ONLY)
}

// -----------------
// GetHelpFileName
// -----------------
// Returns the help filename of the object.
//
LPCSTR WINAPI GetHelpFileName()
{
#ifndef RUN_ONLY
	// Return a file without path if your help file can be loaded by the MMF help file.
//	return "MyExt.chm";

	// Or return the path of your file, relatively to the MMF directory
	// if your file is not loaded by the MMF help file.
	return "Help\\Overlay.html";
#else
	return NULL;
#endif // !defined(RUN_ONLY)
}

// -----------------
// BmpToImg
// -----------------
// Converts an image from the resource to an image displayable under CC&C
// Not used in this template, but it is a good example on how to create
// an image.
//
WORD BmpToImg(int bmID, npAppli idApp, short HotX = 0, short HotY = 0, short ActionX = 0, short ActionY = 0)
{
	Img					ifo;
	WORD				img;
	HRSRC				hs;
	HGLOBAL				hgBuf;
	LPBYTE				adBuf;
	LPBITMAPINFOHEADER	adBmi;

	img = 0;
	if ((hs = FindResource(hInstLib, MAKEINTRESOURCE(bmID), RT_BITMAP)) != NULL)
	{
		if ((hgBuf = LoadResource(hInstLib, hs)) != NULL)
		{
			if ((adBuf = (LPBYTE)LockResource(hgBuf)) != NULL)
			{
				adBmi = (LPBITMAPINFOHEADER)adBuf;
				ifo.imgXSpot = HotX;
				ifo.imgYSpot = HotY;
				ifo.imgXAction = ActionX;
				ifo.imgYAction = ActionY;
				if (adBmi->biBitCount > 4)
					RemapDib((LPBITMAPINFO)adBmi, idApp, NULL);
				img = (WORD)DibToImage(idApp, &ifo, adBmi);
				UnlockResource(hgBuf);
			}
			FreeResource(hgBuf);
		}
	}
	return img;
}


// ============================================================================
//
// ROUTINES USED UNDER FRAME EDITOR
// 
// ============================================================================


// --------------------
// MakeIcon
// --------------------
// Called once object is created or modified, just after setup.
//
// Note: this function is optional. If it's not defined in your extension,
// MMF2 will load the EXO_ICON bitmap if it's defined in your resource file.
//
// If you need to draw the icon manually, remove the comments around this function and in the .def file.
//
/*
int WINAPI DLLExport MakeIconEx ( mv _far *mV, cSurface* pIconSf, LPSTR lpName, fpObjInfo oiPtr, LPEDATA edPtr )
{
	int error = -1;
#ifndef RUN_ONLY
	if ( pIconSf->LoadImage(hInstLib, EXO_ICON) != 0 )
		error = 0;
#endif // !defined(RUN_ONLY)
	return error;
}
*/

// --------------------
// SetupProc
// --------------------
// This routine is yours. You may even not need a setup dialog box.
// I have put it as an example...

#ifndef RUN_ONLY

BOOL CALLBACK DLLExport setupProc(HWND hDlg,uint msgType,WPARAM wParam,LPARAM lParam)
{
	/*
	setupParams	_far *	spa;
	EDITDATA _far *		edPtr;
	int Temp,i;
	EditImageParams eip; 

	switch (msgType)
	{
	case WM_INITDIALOG: // Init dialog
		SetWindowLong(hDlg, DWL_USER, lParam);

		//set checkboxes based on data
		spa = (setupParams far *)lParam;
		edPtr = spa->edpt;
		if(FlagOn(edPtr->Flags,OVLFLAG_DEBUG))
			CheckDlgButton(hDlg,IDC_CHECK_DEBUG,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_STRETCH))
			CheckDlgButton(hDlg,IDC_CHECK_STRETCH,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_AUTOMATIC))
			CheckDlgButton(hDlg,IDC_CHECK_AUTO,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_IMMEDIATE))
			CheckDlgButton(hDlg,IDC_CHECK_IMMED,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_ABSOLUTE))
			CheckDlgButton(hDlg,IDC_CHECK_ABS,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_ANTIA))
			CheckDlgButton(hDlg,IDC_CHECK_ANTIA,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_KEEPPTS))
			CheckDlgButton(hDlg,IDC_CHECK_KEEPPTS,BST_CHECKED);
		if(FlagOn(edPtr->Flags,OVLFLAG_OPAQUE))
		{
			CheckRadioButton(hDlg,IDC_RADIO_OPAQUE,IDC_RADIO_TRANSP,
				IDC_RADIO_OPAQUE);
		}
		else
		{
			CheckRadioButton(hDlg,IDC_RADIO_OPAQUE,IDC_RADIO_TRANSP,
				IDC_RADIO_TRANSP);
		}

		//set edit box
		SetDlgItemInt(hDlg, IDC_EDIT_PARAM, edPtr->EffectParam, FALSE);

		//configure slide bar (trackbar)
		SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETRANGE,TRUE,
				MAKELONG(0,128));
		SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETPOS,TRUE,
				edPtr->EffectParam);
		SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETTIC,0,25);
		SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETTIC,0,50);
		SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETTIC,0,75);
		SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETTIC,0,100);

		//create dropdown list
		for(i = 0; EffectList[i] != NULL; i++)
		{
			SendMessage(GetDlgItem(hDlg,IDC_COMBO_EFFECT),CB_ADDSTRING,0,
				(long)(EffectList[i]));
		}
		//find which item to select
		for(i = 0; EffectCodes[i] != BOP_MAX; i++)
		{
			if(EffectCodes[i] == edPtr->Effect)
			{
				SendMessage(GetDlgItem(hDlg,IDC_COMBO_EFFECT),CB_SETCURSEL,i,0);
				i = EFFECT_CODES-2;  //because for loop adds 1 to it
			}
		}

		//increment image count
		/*if(spa->imgidx != 0 )
			IncImageCount(spa->kv->mvIdAppli, spa->imgidx);
		return TRUE;

	case WM_COMMAND: // Command
		spa = (setupParams far *)GetWindowLong(hDlg, DWL_USER);
		edPtr = spa->edpt;

		switch (wmCommandID)
		{
		case IDC_BUTT_EDIT:  //edit the image (NOTE: 0 = index of image in EnumElts)
			eip.m_dwSize = sizeof(EditImageParams); 
			eip.m_pWindowTitle = NULL; 
			eip.m_dwImage = edPtr->imgidx; 
			eip.m_dwOptions = PICTEDOPT_CANBETRANSPARENT; 
			eip.m_dwFixedWidth = 32; 
			eip.m_dwFixedHeight = 32; 

			if(spa->kv->mvEditImage(edPtr, &eip, hDlg)) 
			{ 
			  edPtr->imgidx = (WORD)eip.m_dwImage;

			}
			//fall through to OK

		case IDOK:
			//save settings
			SetFlag(edPtr->Flags,OVLFLAG_DEBUG,
				IsDlgButtonChecked(hDlg,IDC_CHECK_DEBUG) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_STRETCH,
				IsDlgButtonChecked(hDlg,IDC_CHECK_STRETCH) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_AUTOMATIC,
				IsDlgButtonChecked(hDlg,IDC_CHECK_AUTO) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_IMMEDIATE,
				IsDlgButtonChecked(hDlg,IDC_CHECK_IMMED) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_ABSOLUTE,
				IsDlgButtonChecked(hDlg,IDC_CHECK_ABS) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_OPAQUE,
				IsDlgButtonChecked(hDlg,IDC_RADIO_OPAQUE) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_ANTIA,
				IsDlgButtonChecked(hDlg,IDC_CHECK_ANTIA) != FALSE);
			SetFlag(edPtr->Flags,OVLFLAG_KEEPPTS,
				IsDlgButtonChecked(hDlg,IDC_CHECK_KEEPPTS) != FALSE);

			edPtr->Effect = EffectCodes[SendMessage(GetDlgItem(hDlg,IDC_COMBO_EFFECT),
				CB_GETCURSEL,0,0)];
			edPtr->EffectParam = SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),
				TBM_GETPOS,0,0);*/

			//delete old image and save new one
			/*if(edPtr->imgidx != 0)
				DelImage(spa->kv->mvIdAppli, edPtr->imgidx);
			edPtr->imgidx = spa->imgidx;*/
/*
            // End dialog
			EndDialog(hDlg, 0);
			return 0;

		case IDCANCEL:
			//delete temp image
			//DelImage(spa->kv->mvIdAppli, spa->imgidx);

			EndDialog(hDlg, -1);
			return 0;

		case IDC_EDIT_PARAM:  //handle edit box messages
			switch(wmCommandNotif)
			{
			case EN_UPDATE:  //text has been modified
				//if the edit box doesn;t have focus, ignore this
				if(GetDlgItem(hDlg,IDC_EDIT_PARAM) != GetFocus())
					break;

				//get current value and verify that it is within range
				Temp = GetDlgItemInt(hDlg, IDC_EDIT_PARAM, &i, TRUE);
				if(i == FALSE)  //check for error in getting param
					break;
				if(Temp < 0)
				{
					Temp = 0;
					SetDlgItemInt(hDlg, IDC_EDIT_PARAM, 0, FALSE);
				}
				if(Temp > 128)
				{
					Temp = 128;
					SetDlgItemInt(hDlg, IDC_EDIT_PARAM, 128, FALSE);
				}
				//update slider
				SendMessage(GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_SETPOS,TRUE,Temp);
				break;

			default:
				break;
			}
			break;				

		default:
			break;
		}
		break;

	case WM_HSCROLL: // handle scroll commands
		if(GetDlgItem(hDlg,IDC_SLIDER_PARAM) == (HWND)lParam)
		{
			//slider has been adjusted, adjust edit box
			SetDlgItemInt(hDlg, IDC_EDIT_PARAM, SendMessage(
				GetDlgItem(hDlg,IDC_SLIDER_PARAM),TBM_GETPOS,0,0), FALSE);
		}
		break;

	default:
		break;
	}*/

	return FALSE;
}


// --------------------
// ResizeObject
// --------------------
void ResizeObject(mv _far *knpV, LPEDATA edPtr, int w, int h)
{
//	int w = edPtr->swidth;
//	int h = edPtr->sheight;
	cSurface imageSurface;
	LPSURFACE workSurface;

	::LockImageSurface (knpV->mvIdAppli, edPtr->imgidx, imageSurface, LOCKIMAGE_READBLITONLY);
		
	workSurface = new cSurface;
	
	workSurface->Clone(imageSurface, w, h);
	imageSurface.Stretch(*workSurface, 0, 0, w, h, BMODE_OPAQUE, BOP_COPY, 0, 0);

	::UnlockImageSurface (imageSurface);

	Img				ifo;
	LPBYTE			pBits;
	LPBITMAPINFO	pBmi;
	
	WORD	image = 0;
	int		iWidth; //= workSurface->GetWidth();
	int		iHeight; //= workSurface->GetHeight();
	int		iDepth;	//= workSurface->GetDepth();
	
	workSurface->GetInfo(iWidth, iHeight, iDepth);
	

	DWORD		wDIBSize = workSurface->GetDIBSize();
	LPBYTE		pDib = new BYTE[wDIBSize];

	pBmi = (LPBITMAPINFO)pDib;
	pBits = NULL;

	workSurface->SaveImage(pBmi, pBits, SI_NONE);

	ifo.imgXSpot = ifo.imgYSpot = ifo.imgXAction = ifo.imgYAction = 0;
	image = (WORD)DibToImage(knpV->mvIdAppli, &ifo, (LPBITMAPINFOHEADER)pDib);		
	
	if(image !=0)
	{
		DelImage(knpV->mvIdAppli,edPtr->imgidx);
		edPtr->imgidx = image;
	}

	delete [] pDib;
	workSurface->Delete();
	delete workSurface;
}

#endif // !defined(RUN_ONLY)

// --------------------
// CreateObject
// --------------------
// Called when you choose "Create new object". It should display the setup box 
// and initialize everything in the datazone.

int WINAPI DLLExport CreateObject(mv _far *mV, fpLevObj loPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
	//setupParams		spa;
	edPtr->nImages=1;
	edPtr->imgidx=NULL;
	// Set default object flags
	edPtr->sx = 0;
	edPtr->sy = 0;
	edPtr->swidth = 640; /*(mV->mvEditFrame->m_hdr.leWidth <= 640) ? 
		mV->mvEditFrame->m_hdr.leWidth : 640;*/
	edPtr->sheight = 480; /*(mV->mvEditFrame->m_hdr.leHeight <= 480) ?
		mV->mvEditFrame->m_hdr.leHeight : 480;*/

	edPtr->appID = mV->mvIdAppli;


	edPtr->Flags = OVLFLAG_DEFAULT;
	edPtr->Effect = BOP_COPY;
	edPtr->EffectParam = 0;

	// Load a resource bitmap and convert it to an image in main sprite bank
	edPtr->imgidx = BmpToImg(EXO_IMAGE, mV->mvIdAppli);
	ResizeObject(mV,edPtr,edPtr->swidth,edPtr->sheight);

	// Call setup (remove this and return 0 if your object does not need a setup)
	
	//spa.edpt = edPtr;
	//spa.kv = mV;
	//spa.imgidx = edPtr->imgidx;
	//return ((int) DialOpen(hInstLib, MAKEINTRESOURCE(DB_SETUP), mV->mvHEditWin,setupProc, 0, 0, DL_MODAL|DL_CENTER_WINDOW, (LPARAM)(LPBYTE)&spa));
	return 0;
#endif // !defined(RUN_ONLY)

	// Error
	return -1;
}

// --------------------
// SelectPopup
// --------------------
// One of the option from the menu has been selected, and not a default menu option
// automatically handled by CC&C: this routine is then called.
//
BOOL WINAPI EditObject (mv _far *mV, fpObjInfo oiPtr, fpLevObj loPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
			EditImageParams eip;
 			eip.m_dwSize = sizeof(EditImageParams); 
			eip.m_pWindowTitle = NULL; 
			eip.m_dwImage = edPtr->imgidx; 
			eip.m_dwOptions = PICTEDOPT_CANBETRANSPARENT; 
			eip.m_dwFixedWidth = 32; 
			eip.m_dwFixedHeight = 32; 
			
			if(mV->mvEditImage(edPtr,&eip,mV->mvHEditWin)) 
			{ 
				edPtr->imgidx = (WORD)eip.m_dwImage;
				return TRUE;
			}
#endif // !defined(RUN_ONLY)
	return FALSE;
}

// --------------------
// SetEditSize
// --------------------
// Called by CC&C when the object has been resized
//
// Note: remove the comments if your object can be resized (and remove the comments in the .def file)
BOOL WINAPI SetEditSize(LPMV mV, LPEDATA edPtr, int cx, int cy)
{
#ifndef RUN_ONLY
	ResizeObject(mV,edPtr,cx,cy);
#endif // !defined(RUN_ONLY)
	return TRUE;	// OK
}

// --------------------
// PutObject
// --------------------
// Called when each individual object is dropped in the frame.
//
void WINAPI	DLLExport PutObject(mv _far *mV, fpLevObj loPtr, LPEDATA edPtr, ushort cpt)
{
#ifndef RUN_ONLY
#endif // !defined(RUN_ONLY)
}

// --------------------
// RemoveObject
// --------------------
// Called when each individual object is removed from the frame.
//
void WINAPI	DLLExport RemoveObject(mv _far *mV, fpLevObj loPtr, LPEDATA edPtr, ushort cpt)
{
#ifndef RUN_ONLY
	// Is the last object removed?
    if (0 == cpt)
	{
		// Do whatever necessary to remove our data
	}
#endif // !defined(RUN_ONLY)
}

// --------------------
// DuplicateObject
// --------------------
// Called when an object is created from another one (note: should be called CloneObject instead...)
//
void WINAPI DLLExport DuplicateObject(mv __far *mV, fpObjInfo oiPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
#endif // !defined(RUN_ONLY)
}

// --------------------
// GetObjectRect
// --------------------
// Returns the size of the rectangle of the object in the frame editor.
//
void WINAPI DLLExport GetObjectRect(mv _far *mV, RECT FAR *rc, fpLevObj loPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
	cSurface imageSurface;
	::LockImageSurface (mV->mvIdAppli, edPtr->imgidx, imageSurface, LOCKIMAGE_READBLITONLY);

	rc->right = rc->left + imageSurface.GetWidth();
	rc->bottom = rc->top + imageSurface.GetHeight();

	::UnlockImageSurface (imageSurface);
	
#endif // !defined(RUN_ONLY)
	return;
}


// --------------------
// EditorDisplay
// --------------------
// Displays the object under the frame editor
//
// Note: this function is optional. If it's not defined in your extension,
// MMF2 will load and display the EXO_IMAGE bitmap if it's defined in your resource file.
//
// If you need to draw the icon manually, remove the comments around this function and in the .def file.
//
void WINAPI DLLExport EditorDisplay(mv _far *mV, fpObjInfo oiPtr, fpLevObj loPtr, LPEDATA edPtr, RECT FAR *rc)
{
#ifndef RUN_ONLY
	LPSURFACE ps = WinGetSurface((int)mV->mvIdEditWin);
	if ( ps != NULL )
	{
		int x = rc->left;
		int y = rc->top;
		//int w = rc->right-rc->left;
		//int h = rc->bottom-rc->top;
		BOOL bTransp = ((oiPtr->oiHdr.oiInkEffect & EFFECTFLAG_TRANSPARENT) != 0);
		BlitMode bm = (bTransp) ? BMODE_TRANSP : BMODE_OPAQUE;
		BOOL bAntiA = (oiPtr->oiHdr.oiInkEffect & EFFECTFLAG_ANTIALIAS) ? TRUE : FALSE;
		BlitOp bo = (BlitOp)(oiPtr->oiHdr.oiInkEffect & EFFECT_MASK);
		LPARAM boParam = oiPtr->oiHdr.oiInkEffectParam;
		cSurface imageSurface;
		::LockImageSurface (mV->mvIdAppli, edPtr->imgidx, imageSurface, LOCKIMAGE_READBLITONLY);
		imageSurface.Blit(*ps, x, y, bm,bo, boParam,bAntiA);
//		imageSurface.Blit(*ps, x, y, BMODE_TRANSP,BOP_BLEND_REPLACETRANSP, (DWORD)MAKELONG(36,56), FALSE);
		::UnlockImageSurface (imageSurface);
	}
#endif // !defined(RUN_ONLY)
}

// --------------------
// IsTransparent
// --------------------
// This routine tells CC&C if the mouse pointer is over a transparent zone of the object.
// 

extern "C" BOOL WINAPI DLLExport IsTransparent(mv _far *mV, fpLevObj loPtr, LPEDATA edPtr, int dx, int dy)
{
#ifndef RUN_ONLY
	// Write your code here
#endif // !defined(RUN_ONLY)
	return FALSE;
}

// --------------------
// PrepareToWriteObject
// --------------------
// Just before writing the datazone when saving the application, CC&C calls this routine.
// 
void WINAPI	DLLExport PrepareToWriteObject(mv _far *mV, LPEDATA edPtr, fpObjInfo adoi)
{
#ifndef RUN_ONLY
	// Write your code here
#endif // !defined(RUN_ONLY)
}

// --------------------
// GetFilters
// --------------------

BOOL WINAPI GetFilters(LPMV mV, LPEDATA edPtr, DWORD dwFlags, LPVOID pReserved)
{
	// If your extension uses image filters
	if ( (dwFlags & GETFILTERS_IMAGES) != 0 )
		return TRUE;

	// If your extension uses sound filters
//	if ( (dwFlags & GETFILTERS_SOUNDS) != 0 )
//		return TRUE;
	return FALSE;
}

// --------------------
// UsesFile
// --------------------
// Triggers when a file is dropped onto the frame
// Return TRUE if you can create an object from the given file
//
BOOL WINAPI	DLLExport UsesFile (LPMV mV, LPSTR fileName)
{
	BOOL r = FALSE;
#ifndef RUN_ONLY

	// Example: return TRUE if file extension is ".txt"
/*	
	LPSTR	ext, npath;

	if ( fileName != NULL )
	{
		if ( (ext=(LPSTR)malloc(_MAX_EXT)) != NULL )
		{
			if ( (npath=(LPSTR)malloc(_MAX_PATH)) != NULL )
			{
				strcpy(npath, fileName);
				_splitpath(npath, NULL, NULL, NULL, ext);
				if ( _stricmp(ext, ".txt") == 0 )
					r = TRUE;
				free(npath);
			}
			free(ext);
		}
	} */
#endif // !defined(RUN_ONLY)
	return r;
}


// --------------------
// CreateFromFile
// --------------------
// Creates a new object from file
//
void WINAPI	DLLExport CreateFromFile (LPMV mV, LPSTR fileName, LPEDATA edPtr)
{
#ifndef RUN_ONLY
	// Initialize your extension data from the given file
	edPtr->swidth = 32;
	edPtr->sheight = 32;

	// Example: store the filename
	// strcpy(edPtr->myFileName, fileName);
#endif // !defined(RUN_ONLY)
}

// ============================================================================
//
// PROPERTIES
// 
// ============================================================================

// --------------------
// GetProperties
// --------------------
// Inserts properties into the properties of the object.
//
BOOL WINAPI DLLExport GetProperties(LPMV mV, LPEDATA edPtr, BOOL bMasterItem)
{
#ifndef RUN_ONLY
	mvInsertProps(mV, edPtr, Properties, PROPID_TAB_GENERAL, TRUE);
#endif // !defined(RUN_ONLY)

	// OK
	return TRUE;
}

// --------------------
// ReleaseProperties
// --------------------
// Called when the properties are removed from the property window.
//
void WINAPI DLLExport ReleaseProperties(LPMV mV, LPEDATA edPtr, BOOL bMasterItem)
{
#ifndef RUN_ONLY
	// Write your code here
#endif // !defined(RUN_ONLY)
}

// --------------------
// GetPropCreateParam
// --------------------
// Called when a property is initialized and its creation parameter is NULL (in the PropData).
// Allows you, for example, to change the content of a combobox property according to specific settings in the EDITDATA structure.
//
LPARAM WINAPI DLLExport GetPropCreateParam(LPMV mV, LPEDATA edPtr, UINT nPropID)
{
#ifndef RUN_ONLY
	// Example
	// -------
//	if ( nPropID == PROPID_COMBO )
//	{
//		switch (edPtr->sType)
//		{
//		case TYPE1:
//			return (LPARAM)ComboList1;
//		case TYPE2:
//			return (LPARAM)ComboList2;
//		}
//	}
#endif // !defined(RUN_ONLY)
	return NULL;
}

// ----------------------
// ReleasePropCreateParam
// ----------------------
// Called after a property has been initialized.
// Allows you, for example, to free memory allocated in GetPropCreateParam.
//
void WINAPI DLLExport ReleasePropCreateParam(LPMV mV, LPEDATA edPtr, UINT nPropID, LPARAM lParam)
{
#ifndef RUN_ONLY
#endif // !defined(RUN_ONLY)
}

// --------------------
// GetPropValue
// --------------------
// Returns the value of properties that have a value.
// Note: see GetPropCheck for checkbox properties
//
LPVOID WINAPI DLLExport GetPropValue(LPMV mV, LPEDATA edPtr, UINT nPropID)
{
#ifndef RUN_ONLY
	// Example
	// -------
//	switch (nPropID) {
//
//	// Returns a color.
//	case PROPID_COLOR:
//		return new CPropDWordValue(edPtr->dwColor);
//
//	// Returns a string
//	case PROPID_TEXT:
//		return new CPropDataValue(&edPtr->szText[0]);
//
//	// Returns the value of the combo box
//	case PROPID_COMBO:
//		return new CPropDWordValue(edPtr->nComboIndex);
//	}
	switch(nPropID)
	{
	case PROPID_IMAGELST:
		CPropDataValue* pv = new CPropDataValue((edPtr->nImages + 1) * sizeof(WORD), NULL);
            if ( pv != NULL )
            {
                if ( pv->m_pData != NULL )
                {
                    LPWORD pw = (LPWORD)pv->m_pData;
					*pw++ = edPtr->nImages;
					for (WORD w=0; w<edPtr->nImages; w++)
						*pw++ = edPtr->imgidx;
                    return pv;
                }
                pv->Delete();
            }
		break;
	}
#endif // !defined(RUN_ONLY)
	return NULL;
}

// --------------------
// GetPropCheck
// --------------------
// Returns the checked state of properties that have a check box.
//
BOOL WINAPI DLLExport GetPropCheck(LPMV mV, LPEDATA edPtr, UINT nPropID)
{
#ifndef RUN_ONLY
	// Example
	// -------
//	switch (nPropID) {
//
//	// Return 0 (unchecked) or 1 (checked)
//	case PROPID_CHECK:
//		return edPtr->nCheck;
//	}
	switch(nPropID)
	{
	case PROPID_VISIBLE:
		return FlagOn(edPtr->Flags,OVLFLAG_DEBUG);
	case PROPID_STRETCH:
		return FlagOn(edPtr->Flags,OVLFLAG_STRETCH);
	case PROPID_AUTOMATIC:
		return FlagOn(edPtr->Flags,OVLFLAG_AUTOMATIC);
	case PROPID_IMMEDIATE:
		return FlagOn(edPtr->Flags,OVLFLAG_IMMEDIATE);
	case PROPID_ABSOLUTE:
		return FlagOn(edPtr->Flags,OVLFLAG_ABSOLUTE);
	case PROPID_KEEPPOINTS:
		return FlagOn(edPtr->Flags,OVLFLAG_KEEPPTS);
	}
#endif // !defined(RUN_ONLY)
	return 0;		// Unchecked
}

// --------------------
// SetPropValue
// --------------------
// This routine is called by MMF after a property has been modified.
//
void WINAPI DLLExport SetPropValue(LPMV mV, LPEDATA edPtr, UINT nPropID, LPVOID lParam)
{
#ifndef RUN_ONLY
	// Gets the pointer to the CPropValue structure
	CPropValue* pValue = (CPropValue*)lParam;
switch(nPropID)
{
case PROPID_IMAGELST:
        if ( ((CPropDataValue*)pValue)->m_pData != NULL )
        {
            LPWORD pw = (LPWORD)((CPropDataValue*)pValue)->m_pData;
            edPtr->nImages = *pw++;
			for(int u=0;u<edPtr->nImages;u++)
			{
				edPtr->imgidx=*pw++;
			}
		mvInvalidateObject(mV, edPtr);
        }

	break;
}
	// Example
	// -------
//	switch (nPropID) {
//
//	case PROPID_COMBO:
//		// Simply grab the value
//		edPtr->nComboIndex = ((CPropDWordValue*)pValue)->m_dwValue;
//		break;

//	case PROPID_COLOR:
//		// Here too, gets the value
//		edPtr->dwColor = ((CPropDWordValue*)pValue)->m_dwValue;
//		break;

//	case PROPID_TEXT:
//		{
//			// Gets the string
//			LPSTR pStr = (LPSTR)((CPropDataValue*)pValue)->m_pData;
//
//			// You can simply poke the string if your EDITDATA structure has a fixed size,
//			// or have an adaptive size of structure like below
//
//			// If the length is different
//			if (strlen(pStr)!=strlen(edPtr->text))
//			{
//				// Asks MMF to reallocate the structure with the new size
//				LPEDATA pNewPtr = (LPEDATA)mvReAllocEditData(mV, edPtr, sizeof(EDITDATA)+strlen(pStr));
//				
//				// If reallocation worked
//				if (pNewPtr!=NULL)
//				{
//					// Copy the string
//					edPtr=pNewPtr;
//					strcpy(edPtr->text, pStr);
//				}
//			}
//			else
//			{	
//				// Same size : simply copy
//				strcpy(edPtr->text, pStr);
//			}
//		}
//		break;
//	}

	// You may want to have your object redrawn in the frame editor after the modifications,
	// in this case, just call this function
	// mvInvalidateObject(mV, edPtr);

#endif // !defined(RUN_ONLY)
}

// --------------------
// SetPropCheck
// --------------------
// This routine is called by MMF when the user modifies a checkbox in the properties.
//
void WINAPI DLLExport SetPropCheck(LPMV mV, LPEDATA edPtr, UINT nPropID, BOOL nCheck)
{
#ifndef RUN_ONLY
	// Example
	// -------
//	switch (nPropID)
//	{
//	case PROPID_CHECK:
//		edPtr->nCheck = nCheck;
//		mvInvalidateObject(mV, edPtr);
//		mvRefreshProp(mV, edPtr, PROPID_COMBO);
//		break;
//	}
	switch(nPropID)
	{
	case PROPID_VISIBLE:
		SetFlag(edPtr->Flags,OVLFLAG_DEBUG,nCheck);
		mvRefreshProp(mV, edPtr, PROPID_VISIBLE,true);
		break;
	case PROPID_STRETCH:
		SetFlag(edPtr->Flags,OVLFLAG_STRETCH,nCheck);
		mvRefreshProp(mV,edPtr,PROPID_STRETCH,true);
		break;
	case PROPID_AUTOMATIC:
		SetFlag(edPtr->Flags,OVLFLAG_AUTOMATIC,nCheck);
		mvRefreshProp(mV,edPtr,PROPID_AUTOMATIC,true);
		break;
	case PROPID_IMMEDIATE:
		SetFlag(edPtr->Flags,OVLFLAG_IMMEDIATE,nCheck);
		mvRefreshProp(mV,edPtr,PROPID_IMMEDIATE,true);
		break;
	case PROPID_ABSOLUTE:
		SetFlag(edPtr->Flags,OVLFLAG_ABSOLUTE,nCheck);
		mvRefreshProp(mV,edPtr,PROPID_ABSOLUTE,true);
		break;
	case PROPID_KEEPPOINTS:
		SetFlag(edPtr->Flags,OVLFLAG_KEEPPTS,nCheck);
		mvRefreshProp(mV,edPtr,PROPID_KEEPPOINTS,true);
		break;
	}
#endif // !defined(RUN_ONLY)
}

// --------------------
// EditProp
// --------------------
// This routine is called when the user clicks the button of a Button or EditButton property.
//
BOOL WINAPI DLLExport EditProp(LPMV mV, LPEDATA edPtr, UINT nPropID)
{
#ifndef RUN_ONLY

	// Example
	// -------
/*
	if (nPropID==PROPID_EDITCONTENT)
	{
		if ( EditObject(mV, NULL, NULL, edPtr) )
			return TRUE;
	}
*/
if ( nPropID == PROPID_IMAGELST )
    {
			EditImageParams eip;
 			eip.m_dwSize = sizeof(EditImageParams); 
			eip.m_pWindowTitle = NULL; 
			eip.m_dwImage = edPtr->imgidx; 
			eip.m_dwOptions = PICTEDOPT_CANBETRANSPARENT; 
			eip.m_dwFixedWidth = 32; 
			eip.m_dwFixedHeight = 32; 
			
			if(mV->mvEditImage(edPtr,&eip,mV->mvHEditWin)) 
			{ 
				edPtr->imgidx = (WORD)eip.m_dwImage;
			}
			return true;
    }

#endif // !defined(RUN_ONLY)
	return FALSE;
}

// --------------------
// IsPropEnabled
// --------------------
// This routine returns the enabled state of a property.
//
BOOL WINAPI IsPropEnabled(LPMV mV, LPEDATA edPtr, UINT nPropID)
{
#ifndef RUN_ONLY
	// Example
	// -------
/*
	switch (nPropID) {

	case PROPID_CHECK:
		return (edPtr->nComboIndex != 0);
	}
*/
#endif // !defined(RUN_ONLY)
	return TRUE;
}


// ============================================================================
//
// TEXT PROPERTIES
// 
// ============================================================================

// --------------------
// GetTextCaps
// --------------------
// Return the text capabilities of the object under the frame editor.
//
DWORD WINAPI DLLExport GetTextCaps(mv _far *mV, LPEDATA edPtr)
{
	return 0;	// (TEXT_ALIGN_LEFT|TEXT_ALIGN_HCENTER|TEXT_ALIGN_RIGHT|TEXT_ALIGN_TOP|TEXT_ALIGN_VCENTER|TEXT_ALIGN_BOTTOM|TEXT_FONT|TEXT_COLOR);
}

// --------------------
// GetTextFont
// --------------------
// Return the font used the object.
// Note: the pStyle and cbSize parameters are obsolete and passed for compatibility reasons only.
//
BOOL WINAPI DLLExport GetTextFont(mv _far *mV, LPEDATA edPtr, LPLOGFONT plf, LPSTR pStyle, UINT cbSize)
{
#if !defined(RUN_ONLY)
	// Example: copy LOGFONT structure from EDITDATA
	// memcpy(plf, &edPtr->m_lf, sizeof(LOGFONT));
#endif // !defined(RUN_ONLY)

	return TRUE;
}

// --------------------
// SetTextFont
// --------------------
// Change the font used the object.
// Note: the pStyle parameter is obsolete and passed for compatibility reasons only.
//
BOOL WINAPI DLLExport SetTextFont(mv _far *mV, LPEDATA edPtr, LPLOGFONT plf, LPCSTR pStyle)
{
#if !defined(RUN_ONLY)
	// Example: copy LOGFONT structure to EDITDATA
	// memcpy(&edPtr->m_lf, plf, sizeof(LOGFONT));
#endif // !defined(RUN_ONLY)

	return TRUE;
}

// --------------------
// GetTextClr
// --------------------
// Get the text color of the object.
//
COLORREF WINAPI DLLExport GetTextClr(mv _far *mV, LPEDATA edPtr)
{
	// Example
	return 0;	// edPtr->fontColor;
}

// --------------------
// SetTextClr
// --------------------
// Set the text color of the object.
//
void WINAPI DLLExport SetTextClr(mv _far *mV, LPEDATA edPtr, COLORREF color)
{
	// Example
	//edPtr->fontColor = color;
}

// --------------------
// GetTextAlignment
// --------------------
// Get the text alignment of the object.
//
DWORD WINAPI DLLExport GetTextAlignment(mv _far *mV, LPEDATA edPtr)
{
	DWORD dw = 0;
#if !defined(RUN_ONLY)
	// Example
	// -------
/*	if ( (edPtr->eData.dwFlags & ALIGN_LEFT) != 0 )
		dw |= TEXT_ALIGN_LEFT;
	if ( (edPtr->eData.dwFlags & ALIGN_HCENTER) != 0 )
		dw |= TEXT_ALIGN_HCENTER;
	if ( (edPtr->eData.dwFlags & ALIGN_RIGHT) != 0 )
		dw |= TEXT_ALIGN_RIGHT;
	if ( (edPtr->eData.dwFlags & ALIGN_TOP) != 0 )
		dw |= TEXT_ALIGN_TOP;
	if ( (edPtr->eData.dwFlags & ALIGN_VCENTER) != 0 )
		dw |= TEXT_ALIGN_VCENTER;
	if ( (edPtr->eData.dwFlags & ALIGN_BOTTOM) != 0 )
		dw |= TEXT_ALIGN_BOTTOM;
*/
#endif // !defined(RUN_ONLY)
	return dw;
}

// --------------------
// SetTextAlignment
// --------------------
// Set the text alignment of the object.
//
void WINAPI DLLExport SetTextAlignment(mv _far *mV, LPEDATA edPtr, DWORD dwAlignFlags)
{
#if !defined(RUN_ONLY)
	// Example
	// -------
/*	DWORD dw = edPtr->eData.dwFlags;

	if ( (dwAlignFlags & TEXT_ALIGN_LEFT) != 0 )
		dw = (dw & ~(ALIGN_LEFT|ALIGN_HCENTER|ALIGN_RIGHT)) | ALIGN_LEFT;
	if ( (dwAlignFlags & TEXT_ALIGN_HCENTER) != 0 )
		dw = (dw & ~(ALIGN_LEFT|ALIGN_HCENTER|ALIGN_RIGHT)) | ALIGN_HCENTER;
	if ( (dwAlignFlags & TEXT_ALIGN_RIGHT) != 0 )
		dw = (dw & ~(ALIGN_LEFT|ALIGN_HCENTER|ALIGN_RIGHT)) | ALIGN_RIGHT;

	if ( (dwAlignFlags & TEXT_ALIGN_TOP) != 0 )
		dw = (dw & ~(ALIGN_TOP|ALIGN_VCENTER|ALIGN_BOTTOM)) | ALIGN_TOP;
	if ( (dwAlignFlags & TEXT_ALIGN_VCENTER) != 0 )
		dw = (dw & ~(ALIGN_TOP|ALIGN_VCENTER|ALIGN_BOTTOM)) | ALIGN_VCENTER;
	if ( (dwAlignFlags & TEXT_ALIGN_BOTTOM) != 0 )
		dw = (dw & ~(ALIGN_TOP|ALIGN_VCENTER|ALIGN_BOTTOM)) | ALIGN_BOTTOM;

	edPtr->eData.dwFlags = dw;
*/
#endif // !defined(RUN_ONLY)
}


// ============================================================================
//
// ROUTINES USED UNDER EVENT / TIME / STEP-THROUGH EDITOR
// You should not need to change these routines
// 
// ============================================================================

// -----------------
// menucpy
// -----------------
// Internal routine used later, copy one menu onto another
// 
#ifndef RUN_ONLY
void menucpy(HMENU hTargetMenu, HMENU hSourceMenu)
{
	int			n, id, nMn;
	NPSTR		strBuf;
	HMENU		hSubMenu;

	nMn = GetMenuItemCount(hSourceMenu);
	strBuf = (NPSTR)LocalAlloc(LPTR, 80);
	for (n=0; n<nMn; n++)
	{
		if (0 == (id = GetMenuItemID(hSourceMenu, n)))
			AppendMenu(hTargetMenu, MF_SEPARATOR, 0, 0L);
		else
		{
			GetMenuString(hSourceMenu, n, strBuf, 80, MF_BYPOSITION);
			if (id != -1)
				AppendMenu(hTargetMenu, GetMenuState(hSourceMenu, n, MF_BYPOSITION), id, strBuf);
			else
			{
				hSubMenu = CreatePopupMenu();
				AppendMenu(hTargetMenu, MF_POPUP | MF_STRING, (uint)hSubMenu, strBuf);
				menucpy(hSubMenu, GetSubMenu(hSourceMenu, n));
			}
		}
	}
	LocalFree((HLOCAL)strBuf);
}

// -----------------
// GetPopupMenu
// -----------------
// Internal routine used later. Returns the first popup from a menu
// 
HMENU GetPopupMenu(short mn)
{
	HMENU	hMn, hSubMenu, hPopup = NULL;

	if ((hMn = LoadMenu(hInstLib, MAKEINTRESOURCE(mn))) != NULL)
	{
		if ((hSubMenu = GetSubMenu(hMn, 0)) != NULL)
		{
			if ((hPopup = CreatePopupMenu()) != NULL)
				menucpy(hPopup, hSubMenu);
		}
		DestroyMenu(hMn);
	}
	return hPopup;
}

// --------------------
// GetEventInformations
// --------------------
// Internal routine used later. Look for one event in one of the eventInfos array...
// No protection to go faster: you must properly enter the conditions/actions!
// 
static LPEVENTINFOS2 GetEventInformations(LPEVENTINFOS2 eiPtr, short code)

{
	while(eiPtr->infos.code != code)
		eiPtr = EVINFO2_NEXT(eiPtr);
	
	return eiPtr;
}
#endif // !defined(RUN_ONLY)


// ----------------------------------------------------
// GetConditionMenu / GetActionMenu / GetExpressionMenu
// ----------------------------------------------------
// Load the condition/action/expression menu from the resource, eventually
// enable or disable some options, and returns it to CC&C.
//
HMENU WINAPI DLLExport GetConditionMenu(mv _far *mV, fpObjInfo oiPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
	// Check compatibility
	if ( IS_COMPATIBLE(mV) )
		return GetPopupMenu(MN_CONDITIONS);
#endif // !defined(RUN_ONLY)
	return NULL;
}

HMENU WINAPI DLLExport GetActionMenu(mv _far *mV, fpObjInfo oiPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
	// Check compatibility
	if ( IS_COMPATIBLE(mV) )
		return GetPopupMenu(MN_ACTIONS);
#endif // !defined(RUN_ONLY)
	return NULL;
}

HMENU WINAPI DLLExport GetExpressionMenu(mv _far *mV, fpObjInfo oiPtr, LPEDATA edPtr)
{
#ifndef RUN_ONLY
	// Check compatibility
	if ( IS_COMPATIBLE(mV) )
		return GetPopupMenu(MN_EXPRESSIONS);
#endif // !defined(RUN_ONLY)
	return NULL;
}


// -------------------------------------------------------
// GetConditionTitle / GetActionTitle / GetExpressionTitle
// -------------------------------------------------------
// Returns the title of the dialog box displayed when entering
// parameters for the condition, action or expressions, if any.
// Here, we simply return the title of the menu option
//

#ifndef RUN_ONLY
void GetCodeTitle(LPEVENTINFOS2 eiPtr, short code, short param, short mn, LPSTR strBuf, WORD maxLen)
{
	HMENU		hMn;

	// Finds event in array
	eiPtr=GetEventInformations(eiPtr, code);

	// If a special string is to be returned
	short strID = EVINFO2_PARAMTITLE(eiPtr, param);

	if ( strID != 0 )
		LoadString(hInstLib, strID, strBuf, maxLen);
	else
	{
		// Otherwise, returns the menu option 
		if ((hMn = LoadMenu(hInstLib, MAKEINTRESOURCE(mn))) != NULL )
		{
			GetMenuString(hMn, eiPtr->menu, strBuf, maxLen, MF_BYCOMMAND);
			DestroyMenu(hMn);
		}
	}
}
#else
#define GetCodeTitle(a,b,c,d,e,f)
#endif // !defined(RUN_ONLY)

void WINAPI DLLExport GetConditionTitle(mv _far *mV, short code, short param, LPSTR strBuf, short maxLen)
{
	GetCodeTitle((LPEVENTINFOS2)conditionsInfos, code, param, MN_CONDITIONS, strBuf, maxLen);
}
void WINAPI DLLExport GetActionTitle(mv _far *mV, short code, short param, LPSTR strBuf, short maxLen)
{
	GetCodeTitle((LPEVENTINFOS2)actionsInfos, code, param, MN_ACTIONS, strBuf, maxLen);
}
void WINAPI DLLExport GetExpressionTitle(mv _far *mV, short code, LPSTR strBuf, short maxLen)
{
	GetCodeTitle((LPEVENTINFOS2)expressionsInfos, code, 0, MN_EXPRESSIONS, strBuf, maxLen);
}

// -------------------------------------------------------
// GetConditionTitle / GetActionTitle / GetExpressionTitle
// -------------------------------------------------------
// From a menu ID, these routines returns the code of the condition,
// action or expression, as defined in the .H file
//

short WINAPI DLLExport GetConditionCodeFromMenu(mv _far *mV, short menuId)
{
#ifndef RUN_ONLY
	LPEVENTINFOS2	eiPtr;
	int				n;

	for (n=CND_LAST, eiPtr=(LPEVENTINFOS2)conditionsInfos; n>0 && eiPtr->menu!=menuId; n--)
		eiPtr = EVINFO2_NEXT(eiPtr);
	if (n>0) 
		return eiPtr->infos.code;
#endif // !defined(RUN_ONLY)
	return -1;
}

short WINAPI DLLExport GetActionCodeFromMenu(mv _far *mV, short menuId)
{
#ifndef RUN_ONLY
	LPEVENTINFOS2	eiPtr;
	int				n;

	for (n=ACT_LAST, eiPtr=(LPEVENTINFOS2)actionsInfos; n>0 && eiPtr->menu!=menuId; n--)
		eiPtr = EVINFO2_NEXT(eiPtr);
	if (n>0) 
		return eiPtr->infos.code;
#endif // !defined(RUN_ONLY)
	return -1;
}

short WINAPI DLLExport GetExpressionCodeFromMenu(mv _far *mV, short menuId)
{
#ifndef RUN_ONLY
	LPEVENTINFOS2	eiPtr;
	int				n;

	for (n=EXP_LAST, eiPtr=(LPEVENTINFOS2)expressionsInfos; n>0 && eiPtr->menu!=menuId; n--)
		eiPtr = EVINFO2_NEXT(eiPtr);
	if (n>0) 
		return eiPtr->infos.code;
#endif // !defined(RUN_ONLY)
	return -1;
}


// -------------------------------------------------------
// GetConditionInfos / GetActionInfos / GetExpressionInfos
// -------------------------------------------------------
// From a action / condition / expression code, returns 
// an infosEvents structure. 
//

LPINFOEVENTSV2 WINAPI DLLExport GetConditionInfos(mv _far *mV, short code)
{
#ifndef RUN_ONLY
	return &GetEventInformations((LPEVENTINFOS2)conditionsInfos, code)->infos;
#else
	return NULL;
#endif // !defined(RUN_ONLY)
}

LPINFOEVENTSV2 WINAPI DLLExport GetActionInfos(mv _far *mV, short code)
{
#ifndef RUN_ONLY
	return &GetEventInformations((LPEVENTINFOS2)actionsInfos, code)->infos;
#else
	return NULL;
#endif // !defined(RUN_ONLY)
}

LPINFOEVENTSV2 WINAPI DLLExport GetExpressionInfos(mv _far *mV, short code)
{
#ifndef RUN_ONLY
	return &GetEventInformations((LPEVENTINFOS2)expressionsInfos, code)->infos;
#else
	return NULL;
#endif // !defined(RUN_ONLY)
}


// ----------------------------------------------------------
// GetConditionString / GetActionString / GetExpressionString
// ----------------------------------------------------------
// From a action / condition / expression code, returns 
// the string to use for displaying it under the event editor
//

void WINAPI DLLExport GetConditionString(mv _far *mV, short code, LPSTR strPtr, short maxLen)
{
#ifndef RUN_ONLY
	// Check compatibility
	if ( IS_COMPATIBLE(mV) )
		LoadString(hInstLib, GetEventInformations((LPEVENTINFOS2)conditionsInfos, code)->string, strPtr, maxLen);
#endif // !defined(RUN_ONLY)
}

void WINAPI DLLExport GetActionString(mv _far *mV, short code, LPSTR strPtr, short maxLen)
{
#ifndef RUN_ONLY
	// Check compatibility
	if ( IS_COMPATIBLE(mV) )
		LoadString(hInstLib, GetEventInformations((LPEVENTINFOS2)actionsInfos, code)->string, strPtr, maxLen);
#endif // !defined(RUN_ONLY)
}

void WINAPI DLLExport GetExpressionString(mv _far *mV, short code, LPSTR strPtr, short maxLen)
{
#ifndef RUN_ONLY
	// Check compatibility
	if ( IS_COMPATIBLE(mV) )
		LoadString(hInstLib, GetEventInformations((LPEVENTINFOS2)expressionsInfos, code)->string, strPtr, maxLen);
#endif // !defined(RUN_ONLY)
}

// ----------------------------------------------------------
// GetExpressionParam
// ----------------------------------------------------------
// Returns the parameter name to display in the expression editor
//
void WINAPI DLLExport GetExpressionParam(mv _far *mV, short code, short param, LPSTR strBuf, short maxLen)
{
#if !defined(RUN_ONLY)
	short		strID;

	// Finds event in array
	LPEVENTINFOS2 eiPtr=GetEventInformations((LPEVENTINFOS2)expressionsInfos, code);

	// If a special string is to be returned
	strID = EVINFO2_PARAMTITLE(eiPtr, param);
	if ( strID != 0 )
		LoadString(hInstLib, strID, strBuf, maxLen);
	else
		*strBuf=0;
#endif // !defined(RUN_ONLY)
}

// ----------------------------------------------------------
// Custom Parameters
// ----------------------------------------------------------

// --------------------
// InitParameter
// --------------------
// Initialize the parameter.
//
void WINAPI InitParameter(mv _far *mV, short code, paramExt* pExt)
{
#if !defined(RUN_ONLY)
	// Example
	// -------
	// strcpy(&pExt->pextData[0], "Parameter Test");
	// pExt->pextSize = sizeof(paramExt) + strlen(pExt->pextData)+1;
#endif // !defined(RUN_ONLY)
}

// Example of custom parameter setup proc
// --------------------------------------
/*
#if !defined(RUN_ONLY)
BOOL CALLBACK DLLExport SetupProc(HWND hDlg, UINT msgType, WPARAM wParam, LPARAM lParam)
{
	paramExt*			pExt;

	switch (msgType)
	{
		case WM_INITDIALOG: // Init dialog

			// Save edptr
			SetWindowLong(hDlg, DWL_USER, lParam);
			pExt=(paramExt*)lParam;

			SetDlgItemText(hDlg, IDC_EDIT, pExt->pextData);
			return TRUE;

		case WM_COMMAND: // Command

			// Retrieve edptr
			pExt = (paramExt *)GetWindowLong(hDlg, DWL_USER);

			switch (wmCommandID)
			{
			case IDOK:	// Exit
				GetDlgItemText(hDlg, IDC_EDIT, pExt->pextData, 500);
				pExt->pextSize=sizeof(paramExt)+strlen(pExt->pextData)+1;
				EndDialog(hDlg, TRUE);
				return TRUE;

				default:
					break;
			}
			break;

		default:
			break;
	}
	return FALSE;
}
#endif // !defined(RUN_ONLY)
*/

// --------------------
// EditParameter
// --------------------
// Edit the parameter.
//
void WINAPI EditParameter(mv _far *mV, short code, paramExt* pExt)
{
#if !defined(RUN_ONLY)

	// Example
	// -------
	// DialogBoxParam(hInstLib, MAKEINTRESOURCE(DB_TRYPARAM), mV->mvHEditWin, SetupProc, (LPARAM)(LPBYTE)pExt);

#endif // !defined(RUN_ONLY)
}

// --------------------
// GetParameterString
// --------------------
// Initialize the parameter.
//
void WINAPI GetParameterString(mv _far *mV, short code, paramExt* pExt, LPSTR pDest, short size)
{
#if !defined(RUN_ONLY)

	// Example
	// -------
	// wsprintf(pDest, "Super parameter %s", pExt->pextData);

#endif // !defined(RUN_ONLY)
}

